package ibase.webitm.ejb;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import oracle.sql.CLOB;

@Stateless
public class UploadFileEJB implements UploadFileLocal, UploadFileRemote //implements SessionBean 
{	
	/*public HashMap getObjList(String profileId)throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> objListMap = new HashMap() ; 
		try 
		{
			//Query Changed by Royston on 25/07/2011
			//String objMapQuery =" SELECT  SUBSTR (I.WIN_NAME , 3 ,LENGTH(I.WIN_NAME)) AS OBJ_NAME FROM USERS U ,USER_RIGHTS UR , ITM2MENU I WHERE U.CODE = ? AND U.PROFILE_ID = UR.PROFILE_ID AND UR.RIGHTS IN('*','U') AND I.APPLICATION = UR.APPLICATION AND I.WIN_NAME != '-' ";
			//Changed by gayatri [to add obj_type in where condition]
			String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
					"WHERE PROFILE_ID =  ? AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
					"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')" +
					"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
			String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
			"WHERE PROFILE_ID =  ? AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
			"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
			"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" +
			"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5"; 
			//Commented by Amit D on 30 Dec 13. Added additional check is if rights are '*' and exclude rights char not contains 'U' then select
			String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
					//"WHERE PROFILE_ID =  ? AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId) +" AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
					"AND ( A.RIGHTS LIKE '%U%' or (A.RIGHTS LIKE '%*%' AND  (A.EXCLUDE_RIGHTS_CHAR NOT LIKE '%U%' OR A.EXCLUDE_RIGHTS_CHAR IS NULL ))) AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" +
					"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";

			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			
			pstmt = conn.prepareStatement(objMapQuery);			
			String objName = "";
			String desc = "";
			//pstmt.setString(1,profileId );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					objName = rs.getString("WIN_NAME");
					if(objName != null && objName.indexOf("w") == 0 && objName.indexOf("_") == 1)
					{
						objName = objName.substring(2);
					}
					desc = rs.getString("DESCR");
					objListMap.put(objName, desc);
				}
				while(rs.next());
			}
			else
			{
				BaseLogger.log("3", userInfo,  null,"rs is null");
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return objListMap;
		
	}*/
	/*public HashMap getExistingTemplate(String objName )throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> existingTemplateList = new HashMap() ; 
		
		try
		{
			// .getClobval() is added by Amit D on 01 Jan 13.
			String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML , TEMPLATE.TEMPLATE_XML_NEW.getClobval() FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.OBJ_NAME =?";
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getExistingTemplate);
			pstmt.setString(1, objName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					//Changed by Prasad on 13/07/16 [returning template name with trim] START
					//existingTemplateList.put(rs.getString("TEMPLATE_NAME"),rs.getString(3));
					String templateName = E12GenericUtility.checkNull( rs.getString("TEMPLATE_NAME") );
					existingTemplateList.put( templateName, rs.getString(3) );
					//Changed by Prasad on 13/07/16 [returning template name with trim] END
				}
				while(rs.next());
			}
			
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return existingTemplateList;
	}*/
	/*public String saveTemplate(String objName, String tempName, String xmlString ,String isDefault)throws RemoteException, ITMException
	{
		String respString = null;
		ConnDriver connDriver = null;
		connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			conn = connDriver.getConnectDB("Driver");
			String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME= ? ";
			pstmt = conn.prepareStatement(getTemplateCount);
			pstmt.setString(1, tempName);
			rs = pstmt.executeQuery();
			pstmt = null ;
			if(rs.next())
			{
				if(rs.getInt(1)== 0)
				{
					
					String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT,TEMPLATE_XML_NEW) VALUES (?,?,?,?,XMLType(?))";
					BaseLogger.log("3", userInfo,  null,"insertTemplate = "+insertTemplate);
					pstmt = conn.prepareStatement(insertTemplate);
					pstmt.setString(1, objName);
					pstmt.setString(2, tempName);
					pstmt.setString(3, ""); 
					pstmt.setString(4, isDefault);
					CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					xmlData.putString( 1, xmlString );         
					pstmt.setClob(5, xmlData);
				}
				else
				{
					String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = XMLType(?) WHERE  TEMPLATE_NAME = ? AND OBJ_NAME = ? ";
					BaseLogger.log("3", userInfo,  null,"updateTemplate = "+updateTemplate);
					pstmt = conn.prepareStatement(updateTemplate);
					pstmt.setString(1, "");
					pstmt.setString(2, isDefault);
					// Added by Amit D on 1 Jan 13
					CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					xmlData.putString( 1, xmlString );         
					pstmt.setClob(3, xmlData);
					pstmt.setString(4, tempName); 
					pstmt.setString(5, objName);
				}
				int result = pstmt.executeUpdate();
				if(result >0)
				{
					respString = "Template saved in database";
				}
				else
				{
					respString = "Error while saving template";
				}
			}
			if(conn!=null)
			{
				conn.commit();
			}
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return respString;
		
	}*/
	/*public String getTemplateXml (String tempName)throws RemoteException, ITMException
	{
		String xmlString = "";
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
	
		try
		{
			
			//String getExistingTemplate = "SELECT TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
			String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_XML_NEW.getClobval()  FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.TEMPLATE_NAME =?";
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getExistingTemplate);
			pstmt.setString(1, tempName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				xmlString = rs.getString(1);
			}
			
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return xmlString;
	}*/
	/*public String getSqlValue(String sqlString, String sqlInput)throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String respString = "";
		
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			BaseLogger.log("3", userInfo,  null,"sqlString = ["+sqlString+"] , sqlInput = ["+sqlInput+"]");
			pstmt = conn.prepareStatement(sqlString);
			if(sqlInput.contains(","))
			{
				String[] sqlInputArray = sqlInput.split(",");
				
				for(int i= 0 ; i < sqlInputArray.length; i++)
				{
					BaseLogger.log("3", userInfo,  null,"input value = "+sqlInputArray[i]);
					pstmt.setString(i+1, sqlInputArray[i] );
				}
			}
			else
			{
				pstmt.setString(1, sqlInput );
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				respString = rs.getString(1);
				BaseLogger.log("3", userInfo,  null," respString in getSqlValue = " +respString);
			}
		}
		catch(Exception e)
		{
			
			respString = "exception"+e.getMessage();
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		
	return respString;	
	}*/
	/*public boolean getIsDefault(String tempName)throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String respString = "";
		boolean isDefault = false;
		try
		{
			String getIsDefault = "SELECT IS_DEFAULT FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getIsDefault);
			pstmt.setString(1, tempName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if("Y".equalsIgnoreCase(rs.getString(1)))
				{
					isDefault = true;
				}
			}
			
			
		}
		catch(Exception e)
		{
			
			respString = "exception"+e.getMessage();
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		
	return isDefault;	
	}*/
	/*public ArrayList getDefaultTemp(String objName)throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList defaultTemp = new ArrayList();
		try
		{
			String getDefaultTemp = "SELECT TEMPLATE_NAME ,TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND IS_DEFAULT = ?";
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getDefaultTemp);
			pstmt.setString(1, objName );
			pstmt.setString(2, "Y" );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				defaultTemp.add(rs.getString(1));
				defaultTemp.add(rs.getString(2));
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return defaultTemp;
	}*/
	/*public HashMap getErrorData(String batchId, String profileId )throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap errorMap = new HashMap();
		try
		{
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E') ORDER BY TRAN_SL"; // In Clause added by AMit D on 04 Dec.
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			//pstmt.setString(2, "N") ; // Commented by Amit D.
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					HashMap innerMap = new HashMap();
					
					innerMap.put("winName" , rs.getString(1));		
					innerMap.put("tranSl" , rs.getInt(2));
					innerMap.put("loadDate" , rs.getTimestamp(3));
					innerMap.put("errorMessage", rs.getString(4));
					errorMap.put(batchId +"_"+rs.getInt(2) ,innerMap );
					
				}
				while(rs.next());
			}
	    
				
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return errorMap;
	}*/
	/*public TreeMap getSortedErrorData(String batchId, String profileId )throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		TreeMap errorMap = new TreeMap();
		try
		{
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			//Added by Prasad on 11/04/16 [for displaying Uploaded data also in output] - START
			//String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E') ORDER BY TO_NUMBER(TRAN_SL)"; // In Clause added by AMit D on 04 Dec.
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG " +
					" FROM BATCHLOAD " +
					" WHERE  BATCH_ID = ? " +
					" AND LOAD_STAT in ('N','E','Y') " +
					" ORDER BY TO_NUMBER(TRAN_SL)";
			//Added by Prasad on 11/04/16 [for displaying Uploaded data also in output] - END
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			//pstmt.setString(2, "N") ; // Commented by Amit D.
			// Added By Arvind on 23 AUG 14
			// Changed by arvind on 19 Sep 14
			//SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
			SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
			rs = pstmt.executeQuery();
			String loadDate = "";
			if(rs.next())
			{
				do
				{
					HashMap innerMap = new HashMap();
					
					innerMap.put("winName" , rs.getString(1));		
					innerMap.put("tranSl" , rs.getInt(2));
					// Added By Arvind on 23 AUG 14
					//Changed by Prasad on 15/12/17 [to resolve null pointer of date]
					//innerMap.put("loadDate" , (sdf.format(rs.getTimestamp(3))));
					loadDate = rs.getTimestamp(3) != null ? (sdf.format(rs.getTimestamp(3))) : "";
					innerMap.put("loadDate", loadDate);
					innerMap.put("errorMessage", rs.getString(4));
					//Changed by Prasad on 07/01/17 [to set data sorted on tranSl value] START
					//errorMap.put(batchId +"_"+rs.getInt(2) ,innerMap );
					innerMap.put( "batchId", batchId );
					errorMap.put( rs.getInt(2) ,innerMap );
					//Changed by Prasad on 07/01/17 [to set data sorted on tranSl value] END
				}
				while(rs.next());
			}
		}
		catch(Exception e)
		{
			//Changed by Prasad on 15/12/17 [throw exception]
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return errorMap;
	}*/
	/*public boolean getUserAccess (String profileId, String pageName)
	{
		BaseLogger.log("3", userInfo,  null," pageName = "+pageName);
		boolean isAccessible = false;
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Changed by gayatri [order by is not required]
	    String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID = ? AND WIN_NAME IN (?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
					"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')" +
					"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
		//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
		//String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID = ? AND WIN_NAME IN (?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
		String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID IN "+E12GenericUtility.getFormattedProfileId(profileId)+" AND WIN_NAME IN (?, ?, ?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
		"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
		"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')";
	  
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getUserAccess);
			//pstmt.setString(1, profileId) ;
			if(pageName.equals("Apply_Default_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp") ;
			}
			else if(pageName.equals("Upload_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12UploadTemplate.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12UploadTemplate.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12UploadTemplate.jsp") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12UploadTemplate.jsp") ;
			}
			else if(pageName.equals("Process_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12ProcessTemplate.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12ProcessTemplate.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12ProcessTemplate.jsp") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12ProcessTemplate.jsp") ;
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if(rs.getInt(1) > 0 )
				{
					isAccessible = true;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return  isAccessible;
	
	}*/
	
	//Overloaded methods Added By Arvind/Shahu Mali on  10-10-13.[WS3GBAS001] to support MultiDB connection :START
	public boolean getIsDefault(String tempName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String respString = "";
		boolean isDefault = false;
		String transDB = null;
		try
		{

			transDB=userInfo.getTransDB();
			
			String getIsDefault = "SELECT IS_DEFAULT FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
			connDriver = new ConnDriver();

			//if(transDB!=null && (transDB.trim().length() >0 ))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getIsDefault);
			pstmt.setString(1, tempName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if("Y".equalsIgnoreCase(rs.getString(1)))
				{
					isDefault = true;
				}
			}
		}
		catch(Exception e)
		{
			respString = "exception"+e.getMessage();
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		
	return isDefault;	
	}
	public HashMap getErrorData(String batchId, String profileId,UserInfoBean userInfo )throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap errorMap = new HashMap();
		String transDB = null;
		try
		{
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			transDB=userInfo.getTransDB();
			
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT = ?";
			connDriver = new ConnDriver();

			//if(transDB!=null && (transDB.trim().length() >0 ))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			pstmt.setString(2, "N") ;
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					HashMap innerMap = new HashMap();
					
					innerMap.put("winName" , rs.getString(1));		
					innerMap.put("tranSl" , rs.getInt(2));
					innerMap.put("loadDate" , rs.getTimestamp(3));
					innerMap.put("errorMessage", rs.getString(4));
								
					errorMap.put(batchId +"_"+rs.getInt(2) ,innerMap );
					
				}
				while(rs.next());
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return errorMap;
	}
	public ArrayList getDefaultTemp(String objName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList defaultTemp = new ArrayList();
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();
			
			String getDefaultTemp = "SELECT TEMPLATE_NAME ,TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND IS_DEFAULT = ?";
			connDriver = new ConnDriver();
			//if(transDB!=null && (transDB.trim().length() >0 ))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getDefaultTemp);
			pstmt.setString(1, objName );
			pstmt.setString(2, "Y" );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				defaultTemp.add(rs.getString(1));
				defaultTemp.add(rs.getString(2));
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return defaultTemp;
	}
	
	//Changed by Prasad on 11/05/2021 [adding columns from batchload] START
	public TreeMap getSortedErrorData(String batchId, String profileId, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		return getSortedErrorData(batchId, profileId, null, userInfo, null);
	}
	
	public TreeMap getSortedErrorData(String batchId, String profileId, String tranSl, UserInfoBean userInfo, Connection conn )throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;  
		//Connection conn = null;
		boolean isLocalConn = false;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		TreeMap errorMap = new TreeMap();
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			//Added by Prasad on 11/04/16 [for displaying Uploaded data also in output] - START
			/*String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E') ORDER BY TO_NUMBER(TRAN_SL)";*/ // In Clause added by AMit D on 04 Dec.
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, "
					+ " CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG, "
					+ " LOAD_STAT, TRAN_ID__REF, DATA_FILE_NAME, XFRM_TEMPLATE, THREAD_KEY, LOAD_ORDER, DEPENDENCY, EDI_ADDR, ADD_DATE, ADD_USER, CHG_DATE, CHG_USER " +
					" FROM BATCHLOAD " +
					" WHERE BATCH_ID = ? ";
			if ( tranSl != null )
			{
				getErrorData += " AND TRAN_SL = '"+ tranSl +"' ";
			}
			else
			{
				getErrorData += " AND LOAD_STAT in ('N','E','Y') " +
						" ORDER BY TO_NUMBER(TRAN_SL)";
			}
			//Added by Prasad on 11/04/16 [for displaying Uploaded data also in output] - END
			connDriver = new ConnDriver();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			if ( conn == null )
			{
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;
				isLocalConn = true;
			}
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			//pstmt.setString(2, "N") ; // Commented by Amit D.
			SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
			rs = pstmt.executeQuery();
			String loadDate = "";
			String addDate = "";
			String chgDate = "";
			if(rs.next())
			{
				do
				{
					HashMap innerMap = new HashMap();
					
					innerMap.put("winName", rs.getString("WIN_NAME"));
					innerMap.put("tranSl", rs.getInt("TRAN_SL"));
					//innerMap.put("loadDate" , rs.getTimestamp(3));
					//Changed by Prasad on 15/12/17 [to resolve null pointer of date]
					//innerMap.put("loadDate" , (sdf.format(rs.getTimestamp(3))));
					loadDate = rs.getTimestamp("LOAD_DATE") != null ? (sdf.format(rs.getTimestamp("LOAD_DATE"))) : "";
					innerMap.put("loadDate", loadDate);
					innerMap.put("errorMessage", rs.getString("ERROR_MSG"));
					//Changed by Prasad on 07/01/17 [to set data sorted on tranSl value] START
					innerMap.put("batchId", batchId);
					
					innerMap.put("loadStat", rs.getString("LOAD_STAT"));
					innerMap.put("tranIdRef", rs.getString("TRAN_ID__REF"));
					innerMap.put("dataFileName", rs.getString("DATA_FILE_NAME"));
					innerMap.put("xfrmTemplate", rs.getString("XFRM_TEMPLATE"));
					innerMap.put("threadKey", rs.getString("THREAD_KEY"));
					innerMap.put("loadOrder", rs.getString("LOAD_ORDER"));
					innerMap.put("dependency", rs.getString("DEPENDENCY"));
					innerMap.put("ediAddr", rs.getString("EDI_ADDR"));
					addDate = rs.getTimestamp("ADD_DATE") != null ? (sdf.format(rs.getTimestamp("ADD_DATE"))) : "";
					innerMap.put("addDate", addDate);
					innerMap.put("addUser", rs.getString("ADD_USER"));
					chgDate = rs.getTimestamp("CHG_DATE") != null ? (sdf.format(rs.getTimestamp("CHG_DATE"))) : "";
					innerMap.put("chgDate", chgDate);
					innerMap.put("chgUser", rs.getString("CHG_USER"));
					
					errorMap.put( rs.getInt("TRAN_SL"), innerMap );
					//Changed by Prasad on 07/01/17 [to set data sorted on tranSl value] END
				}
				while(rs.next());
			}
		}
		catch(Exception e)
		{
			//Changed by Prasad on 15/12/17 [throw exception]
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return errorMap;
	}
	//Changed by Prasad on 11/05/2021 [adding columns from batchload] END
	
	public String getSqlValue(String sqlString, String sqlInput, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,  null,"UploadFileEjb called");
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String respString = "";
		
		try
		{
			connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			BaseLogger.log("3", userInfo,  null,"sqlString = ["+sqlString+"] , sqlInput[= "+sqlInput+"]");
			pstmt = conn.prepareStatement(sqlString);
			if(sqlInput.contains(","))
			{
				String[] sqlInputArray = sqlInput.split(",");
				
				for(int i= 0 ; i < sqlInputArray.length; i++)
				{
					BaseLogger.log("3", userInfo,  null,"input value = "+sqlInputArray[i]);
					pstmt.setString(i+1, sqlInputArray[i] );
				}
			}
			else
			{
				pstmt.setString(1, sqlInput );
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				respString = rs.getString(1);
				BaseLogger.log("3", userInfo,  null," respString in getSqlValue = " +respString);
			}
		}
		catch(Exception e)
		{
			respString = "exception"+e.getMessage();
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		
		return respString;	
	}
	
	//Added By Ravindra C on 02-04-18 for upload Utilty 
	//public HashMap<String, String> getObjList(String profileId, UserInfoBean userInfo)throws RemoteException, ITMException
	public HashMap<String, String> getObjList(String profileId, UserInfoBean userInfo, String caller )throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
			
		HashMap<String, String> objListMap = new HashMap<String, String>() ; 
		try 
		{
			//Query Changed by Royston on 25/07/2011
			//String objMapQuery =" SELECT  SUBSTR (I.WIN_NAME , 3 ,LENGTH(I.WIN_NAME)) AS OBJ_NAME FROM USERS U ,USER_RIGHTS UR , ITM2MENU I WHERE U.CODE = ? AND U.PROFILE_ID = UR.PROFILE_ID AND UR.RIGHTS IN('*','U') AND I.APPLICATION = UR.APPLICATION AND I.WIN_NAME != '-' ";
			//Changed by gayatri [to add obj_type in where condition]
			/*String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
					"WHERE PROFILE_ID =  ? AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
					"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')" +
					"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/
			/*String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
			"WHERE PROFILE_ID =  ? AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
			"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
			"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" +
			"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/ 
			//Commented by Amit D on 30 Dec 13. Added additional check is if rights are '*' and exclude rights char not contains 'U' then select
			connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			String userLev = userInfo.getUserLevel();
			String objMapQuery = "";
			// Changed by Ravindra C on 02-04-18 for process template- Start
			if( "Process_Temp".equalsIgnoreCase( caller ) )
			{
				//Added By Ravindra C on 17-04-18 for Multiple ProfileId
				String userId=userInfo.getLoginCode();
				BaseLogger.log("3", userInfo,  null, "profile=========>["+ profileId +"]" );
				String profileQureyCond = appendProfileIdQueryCond( profileId ); 
				
				BaseLogger.log("3", userInfo,  null, "profileQureyCond=========>["+ profileQureyCond +"]" );
				
				objMapQuery="SELECT DISTINCT MENU.WIN_NAME, MENU.DESCR "
						+ " FROM OBJ_FILE_TEMPLATE TEMP, ITM2MENU MENU "
						+ " WHERE MENU.WIN_NAME = 'w_' || TEMP.OBJ_NAME "
						+ " AND ( TEMP.CHG_USER = ? "
						+ " OR TEMP.SHARE_SCOPE = '2' "
						+ " OR ( TEMP.SHARE_SCOPE = '3' "+ profileQureyCond +" )"
						+ " OR ( TEMP.SHARE_SCOPE = '4' AND TEMP.SCOPE_VALUE LIKE '%"+ userId +"%' ) )";
				pstmt = conn.prepareStatement( objMapQuery );
				pstmt.setString( 1, userId );
			}
			// Changed by Ravindra C on 02-04-18 for process template- End			
			else
			{
				if ( "0".equalsIgnoreCase( userLev ) )
				{
					objMapQuery = "SELECT WIN_NAME, DESCR FROM ITM2MENU " +
							" WHERE ( WIN_NAME != NULL OR WIN_NAME != '-' ) " +
							" AND OBJ_TYPE = 'T' " +
							" ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5 ";
					pstmt = conn.prepareStatement( objMapQuery );
				}
				else
				{
					objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B " +
							"WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId) +" AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
							"AND ( A.RIGHTS LIKE '%U%' or (A.RIGHTS LIKE '%*%' AND  (A.EXCLUDE_RIGHTS_CHAR NOT LIKE '%U%' OR A.EXCLUDE_RIGHTS_CHAR IS NULL ))) AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" +
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
					
					pstmt = conn.prepareStatement( objMapQuery );
				}
			}
			
			String objName = "";
			String desc = "";
			/*pstmt = conn.prepareStatement( objMapQuery );
			pstmt.setString( 1, profileId );*/
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					objName = rs.getString("WIN_NAME");
					if(objName != null && objName.indexOf("w") == 0 && objName.indexOf("_") == 1)
					{
						objName = objName.substring(2);
					}
					desc = rs.getString("DESCR");
					objListMap.put(objName, desc);
				}
				while(rs.next());
			}
			else
			{
				BaseLogger.log("3", userInfo,  null,"rs is null");
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return objListMap;
	}
	
	public String getTemplateXml(String tempName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String xmlString = "";
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
	
		try
		{
			//String getExistingTemplate = "SELECT TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
			String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_XML_NEW.getClobval()  FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.TEMPLATE_NAME =?";
			connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getExistingTemplate);
			pstmt.setString(1, tempName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				xmlString = rs.getString(1);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return xmlString;
	}
	public boolean getUserAccess (String profileId, String pageName, UserInfoBean userInfo)
	{
		BaseLogger.log("2", userInfo,  null," pageName = "+pageName);
		boolean isAccessible = false;
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String transDB = null;
		//Changed by gayatri [order by is not required]
	    /*String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID = ? AND WIN_NAME IN (?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
					"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
					"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')" +
					"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/
		//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
		//String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID = ? AND WIN_NAME IN (?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +

		String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID IN "+E12GenericUtility.getFormattedProfileId(profileId)+" AND WIN_NAME IN (?, ?, ?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
				"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
				"AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')";

		try
		{
			transDB=userInfo.getTransDB();
			connDriver = new ConnDriver();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getUserAccess);
			//pstmt.setString(1, profileId) ;
			if(pageName.equals("Apply_Default_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp") ;
			}
			else if(pageName.equals("Upload_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12UploadTemplate.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12UploadTemplate.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12UploadTemplate.jsp?reset=true") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12UploadTemplate.jsp?reset=true") ;
			}
			else if(pageName.equals("Process_Temp"))
			{
				pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/E12ProcessTemplate.jsp") ;
				pstmt.setString(2, "/ibase/jsp/E12ProcessTemplate.jsp") ;
				pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/E12ProcessTemplate.jsp?reset=true") ;
				pstmt.setString(4, "/ibase/webitm/jsp/E12ProcessTemplate.jsp?reset=true") ;
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if(rs.getInt(1) > 0 )
				{
					isAccessible = true;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return  isAccessible;
	
	}
	public HashMap getExistingTemplate(String objName, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> existingTemplateList = new HashMap() ; 
		
		try
		{
			// .getClobval() is added by Amit D on 01 Jan 13.
			String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML , TEMPLATE.TEMPLATE_XML_NEW.getClobval() FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.OBJ_NAME =?";
			connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(getExistingTemplate);
			pstmt.setString(1, objName );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				do
				{
					//Changed by Prasad on 13/07/16 [returning template name with trim] START
					//existingTemplateList.put(rs.getString("TEMPLATE_NAME"),rs.getString(3));
					String templateName = E12GenericUtility.checkNull( rs.getString("TEMPLATE_NAME") );
					existingTemplateList.put( templateName, rs.getString(3) );
					//Changed by Prasad on 13/07/16 [returning template name with trim] END
				}
				while(rs.next());
			}
			
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return existingTemplateList;
	}
	public String saveTemplate(String objName, String tempName, String xmlString ,String isDefault, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		String respString = null;
		ConnDriver connDriver = null;
		connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
			pstmt = conn.prepareStatement(getTemplateCount);
			pstmt.setString(1, tempName);
			pstmt.setString(2, objName);
			rs = pstmt.executeQuery();
			pstmt.close();
			pstmt = null;
			if(rs.next())
			{
				if(rs.getInt(1)== 0)
				{
					String tranId = generateTranId( "w_obj_file_template", conn );
					String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT,TEMPLATE_XML_NEW,TEMPLATE_ID) VALUES (?,?,?,?,XMLType(?),?)";
					BaseLogger.log("3", userInfo,  null,"insertTemplate = "+insertTemplate);
					pstmt = conn.prepareStatement(insertTemplate);
					pstmt.setString(1, objName);
					pstmt.setString(2, tempName);
					pstmt.setString(3, ""); 
					pstmt.setString(4, isDefault);
					CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					xmlData.putString( 1, xmlString );         
					pstmt.setClob(5, xmlData);
					pstmt.setString(6, tranId);
				}
				else
				{
					String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = XMLType(?) WHERE  TEMPLATE_NAME = ? AND OBJ_NAME = ? ";
					BaseLogger.log("3", userInfo,  null,"updateTemplate = "+updateTemplate);
					pstmt = conn.prepareStatement(updateTemplate);
					pstmt.setString(1, "");
					pstmt.setString(2, isDefault);
					// Added by Amit D on 1 Jan 13
					CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					xmlData.putString( 1, xmlString );         
					pstmt.setClob(3, xmlData);
					pstmt.setString(4, tempName); 
					pstmt.setString(5, objName);
				}
				int result = pstmt.executeUpdate();
				if(result >0)
				{
					respString = "Template saved in database";
				}
				else
				{
					respString = "Error while saving template";
				}
			}
			if(conn!=null)
			{
				conn.commit();
			}
		}
		catch(SQLException e)
		{
			BaseLogger.log("0", userInfo,  null, "In SQLException - "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null, "In Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return respString;
		
	}
	//Overloaded methods Added By Arvind/Shahu Mali on  10-10-13.[WS3GBAS001] to support MultiDB connection :END
	//Added by Prasad on 20/09/17 [] START
	@Override
	public HashMap<String, HashMap<String, String>> getTemplateDetail( String objName, String accessFrom, UserInfoBean userInfo ) throws RemoteException, ITMException 
	{
		return getTemplateDetail( objName, accessFrom, null, userInfo );
	}
	
	//Changed by Prasad on 13/12/2020 [to get templateName wise details] START
	public HashMap<String, HashMap<String, String>> getTemplateDetail( String objName, String accessFrom, String templateName, UserInfoBean userInfo ) throws RemoteException, ITMException 
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String rights ="";
		HashMap<String, HashMap<String, String>> templateDetailMap = null;
		
		try
		{
			connDriver = new ConnDriver();
			String loginCode = "";
			String loginUserProfile = "";
			//Added by Prasad on 16/05/18 [to check for multiple user profile]
			List<String> userProfileList = null;
			if ( userInfo != null )
			{
				String transDB = userInfo.getTransDB();
				//if( transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 )
				{
					conn = connDriver.getConnectDB( transDB );
				}
				loginCode = userInfo.getLoginCode();
				//Added by Prasad on 16/05/18 [to check for multiple user profile]
				loginUserProfile = checkNull( userInfo.getProfileId() );
				if ( loginUserProfile.length() > 0 )
				{
					userProfileList = new ArrayList<String>( Arrays.asList( loginUserProfile.split( "\\s*,\\s*" ) ) );
				}
				BaseLogger.log("3", userInfo,  null, "loginCode - ["+ loginCode +"], loginUserProfile - ["+ loginUserProfile +"]" );
			}			
			connDriver = null;
			//Changed By Ravindra C on 21-2-18 [For XmlType To CLOB]
			String templateDetailSQL = " SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML, TEMPLATE.IS_DEFAULT, "
					//+ " TEMPLATE.TEMPLATE_XML_NEW.getClobval() TEMPLATE_XML_NEW, TEMPLATE.FILE_MAPPING.getClobval() FILE_MAPPING,"
					+ " TEMPLATE.TEMPLATE_XML_NEW, TEMPLATE.FILE_MAPPING FILE_MAPPING,"
					+ " TEMPLATE_ID, SHARE_SCOPE, SCOPE_VALUE, ADD_USER, CHG_USER, DOC_ID, RIGHTS_CHAR, AUTO_CONFIRM "
					+ " FROM OBJ_FILE_TEMPLATE TEMPLATE "
					//Changed By Ravindra c on 16-1-19 for delete template
					//+ " WHERE TEMPLATE.OBJ_NAME = ? ";
					+ " WHERE TEMPLATE.OBJ_NAME = ? ";
			//Changed by Prasad on 13/12/2020 [to get templateName wise details] START
			if ( checkNull( templateName ).length() > 0 )
			{
				templateDetailSQL += " AND TEMPLATE.TEMPLATE_NAME = ? ";
			}
			//Changed by Prasad on 13/12/2020 [to get templateName wise details] END
			templateDetailSQL += " AND (TEMPLATE.ACTIVE is null or TEMPLATE.ACTIVE = 'Y') ";
			
			BaseLogger.log("3", userInfo,  null, "templateDetailSQL :: - ["+ templateDetailSQL +"]");
			
			pstmt = conn.prepareStatement(templateDetailSQL);
			pstmt.setString( 1, objName );
			//Changed by Prasad on 13/12/2020 [to get templateName wise details] START
			if ( checkNull( templateName ).length() > 0 )
			{
				pstmt.setString( 2, templateName );
			}
			//Changed by Prasad on 13/12/2020 [to get templateName wise details] END
			rs = pstmt.executeQuery();
			
			if( rs.next() )
			{
				templateDetailMap = new HashMap<String, HashMap<String,String>>();
				do
				{
					String templateId = E12GenericUtility.checkNull( rs.getString("TEMPLATE_ID") );
					templateName = E12GenericUtility.checkNull( rs.getString("TEMPLATE_NAME") );
					String templateXml = E12GenericUtility.checkNull( rs.getString("TEMPLATE_XML") );
					String templateXmlNew = E12GenericUtility.checkNull( rs.getString("TEMPLATE_XML_NEW") );
					String isDefault = E12GenericUtility.checkNull( rs.getString("IS_DEFAULT") );
					String fileMappingXml = E12GenericUtility.checkNull( rs.getString("FILE_MAPPING") );
					String shareScope = E12GenericUtility.checkNull( rs.getString("SHARE_SCOPE") );
					String scopeValue = E12GenericUtility.checkNull( rs.getString("SCOPE_VALUE") );
					String addUser = E12GenericUtility.checkNull( rs.getString("ADD_USER") );
					String chgUser = E12GenericUtility.checkNull( rs.getString("CHG_USER") );
					String docId = E12GenericUtility.checkNull( rs.getString("DOC_ID") );
					String rightsChar = E12GenericUtility.checkNull( rs.getString("RIGHTS_CHAR") );
					//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
					String isAutoConfirm = E12GenericUtility.checkNull( rs.getString("AUTO_CONFIRM") );
					BaseLogger.log("3", userInfo,  null, "shareScope - ["+ shareScope +"]" );
					BaseLogger.log("3", userInfo,  null, "docId - ["+ docId +"]" );
					BaseLogger.log("3", userInfo,  null, "templateName - ["+ templateName +"]" );

					//Added By Ravindra C on 13-11-18 to provide template rights to every profile -Start
					if( scopeValue.length() > 1 && rightsChar.length() == 1  )
					{
						StringBuffer rightsBuff = new StringBuffer();
						String scopeValueArr[] = scopeValue.split(", "); 
						for( int scopeValCtr = 0; scopeValCtr < scopeValueArr.length; scopeValCtr++ )
						{
							rightsBuff = rightsBuff.append(rightsChar + ", ");
						}
						rightsChar = rightsBuff.toString();
						if( rightsChar.length() > 2 )
						{
							rightsChar = rightsChar.substring( 0, rightsChar.length() - 2 );
						}
					}
					//Added By Ravindra C on 13-11-18 to provide template rights to every profile -End
					if ( ! addUser.equals( loginCode ) )
					{
						//Added By Ravindra C on 06-11-18 for template RightCharacter - Start
						List<String> dataList = new ArrayList<String>( Arrays.asList( scopeValue.split( "\\s*,\\s*" ) ) );
						List<String> rightList = new ArrayList<String>( Arrays.asList( rightsChar.split( "\\s*,\\s*" ) ) );
						////Added By Ravindra C on 06-11-18 for template RightCharacter - End
						if ( "1".equalsIgnoreCase( shareScope ) )
						{
							BaseLogger.log("3", userInfo,  null, "addUser - ["+ addUser +"]" );
							if ( ! addUser.equals( loginCode ) )
							{
								continue;
							}
						}
						else if ( "3".equalsIgnoreCase( shareScope ) )
						{
							//Added By Ravindra C on 06-11-18 for template RightCharacter - Start
							boolean profileIdExist = false;
							for (int profileCtr = 0; profileCtr < userProfileList.size(); profileCtr++) 
							{
								String profileId = userProfileList.get(profileCtr);
								for( int dataCtr = 0; dataCtr < dataList.size(); dataCtr++)
								{
									String dataProfile = dataList.get(dataCtr);
									if(dataProfile.equals(profileId) && rightList.size() > 0)
									{
										profileIdExist = true;
										rights = rightList.get(dataCtr);
										break;
									}
								}
							}
							//Added By Ravindra C on 06-11-18 for template RightCharacter - End
							//Commented By Ravindra C on 13-11-18 for user Rights(Add Same logic in above for()) - Start
							//Added by Prasad on 16/05/18 [to check for multiple user profile] START
							/*boolean profileIdExist = false;
							if ( userProfileList != null )
							{
								for ( int profileCnt = 0; profileCnt < userProfileList.size(); profileCnt ++ )
								{
									String profileId = checkNull( userProfileList.get( profileCnt ) );
									BaseLogger.log("3", userInfo,  null, "profileId - ["+ profileId +"]" );
									if ( dataList != null && dataList.contains( profileId ) )
									{
										profileIdExist = true;
										break;
									}
								}
							}*/
							//Commented By Ravindra C on 13-11-18 for user Rights(Add Same logic in above for()) - End
							if ( ! profileIdExist )
							{
								continue;
							}
							//Added by Prasad on 16/05/18 [to check for multiple user profile] END
						}
						else if ( "4".equalsIgnoreCase( shareScope ) )
						{
							//Added By Ravindra C on 06-11-18 for template RightCharacter - Start
							for( int userEntity = 0; userEntity < dataList.size(); userEntity++)
							{
								String entity = dataList.get(userEntity);
								if(entity.equals(loginCode))
								{
									rights = rightList.get(userEntity);
								}
							}
							//Added By Ravindra C on 06-11-18 for template RightCharacter - End

							BaseLogger.log("3", userInfo,  null, "dataList - ["+ dataList +"]" );
							if ( dataList != null && ! dataList.contains( loginCode ) )
							{
								continue;
							}
						}

						if ( "Process_Temp".equalsIgnoreCase( accessFrom ) && ( "E".equalsIgnoreCase( rights ) ) )
						{
							continue;
						}
					}
					
					HashMap<String, String> detailMap = new HashMap<String, String>();
					detailMap.put( "TEMPLATE_NAME", templateName );
					detailMap.put( "TEMPLATE_XML", templateXml );
					detailMap.put( "TEMPLATE_XML_NEW", templateXmlNew );
					detailMap.put( "IS_DEFAULT", isDefault );
					detailMap.put( "FILE_MAPPING", fileMappingXml );
					detailMap.put( "TEMPLATE_ID", templateId );
					detailMap.put( "SHARE_SCOPE", shareScope );
					detailMap.put( "SCOPE_VALUE", scopeValue );
					detailMap.put( "TEMP_DOC_ID", docId );
					detailMap.put( "TEMP_RIGHTS_CHAR", rightsChar );
					detailMap.put( "ADD_USER", addUser );
					detailMap.put( "CHG_USER", chgUser ); 
					detailMap.put( "RIGHTS", rights );
					//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
					detailMap.put( "AUTO_CONFIRM", isAutoConfirm );
					templateDetailMap.put( templateName, detailMap );
				}
				while( rs.next() );
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		System.out.println("getTemplateDetail >> templateDetailMap ::"+templateDetailMap);
		
		return templateDetailMap;
	}
	//Changed by Prasad on 13/12/2020 [to get templateName wise details] END
	
	@Override
	public TreeMap<Integer, String> getFormWiseTitleMap( String objName, UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		
		TreeMap<Integer,String> formDetailInfo = new TreeMap<Integer, String>();
		try
		{
			connDriver = new ConnDriver();
			if ( userInfo != null )
			{
				String transDB = userInfo.getTransDB();
				//if( transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 )
				{
					conn = connDriver.getConnectDB( transDB );
				}
			}
			
			connDriver = null;
			String winName = objName.contains("w_") ? objName : "w_" + objName;

			String sql = " SELECT FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME = ? ORDER BY TO_NUMBER(FORM_NO) ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString( 1, winName );
			rs = pStmt.executeQuery();
			while( rs.next() )
			{
				formDetailInfo.put( rs.getInt("FORM_NO"), rs.getString("TITLE") );
			}
			rs.close(); rs = null;
			pStmt.close(); pStmt = null;
		} 
		catch (Exception e)
		{
			throw new ITMException(e);
		} 
		finally
		{
			if (conn != null) 
			{
				try 
				{
					if(rs !=null)
					{
						rs.close(); 
						rs =null;
					}
					if(pStmt !=null)
					{
						pStmt.close(); 
						pStmt =null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch (SQLException e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
		}
		return formDetailInfo;
	}
	
	//Changed by Ajinkya D on 16-NOV-2017 [For Upload Utility] [START]
	//Changed By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
	@Override
	public String saveTemplate( String tempId, String objName, String tempName, String xmlString, String isDefault, String fileMapping, String shareScope, String scopeValue, String templateRightsChar, String fileName, byte[] byteArray, String filePath, String isDataUploadAutoConfirm, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		String respString = "<Root><Detail>Error</Detail></Root>";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String tranId = "";
		boolean isError = false;
		try
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();

			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;
			conn.setAutoCommit(false);

			if( tempId != null && tempId.length() > 0 )
			{
				tranId = tempId;
			}
			else       
			{
				tranId = generateTranId( "w_obj_file_template", conn );
			}
			BaseLogger.log("3", userInfo,  null,"scopeValue.length() - ["+scopeValue.length()+"]");

			String chgTerm = userInfo.getRemoteHost();
			String loginCode = userInfo.getLoginCode();

			if( scopeValue.length() <= 0 )
			{
				scopeValue = loginCode;
			}

			//added By Ravindra C on 11-04-18 for  -- Start
			String docId = "";
			if ( byteArray != null )
			{
				String documentStr = addDocument( tranId, objName, tempName, fileName, byteArray, filePath, userInfo );
				docId = getDocumentId( documentStr );
			}
			//added By Ravindra C on 11-04-18 for  -- End

			String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
			pstmt = conn.prepareStatement(getTemplateCount);
			pstmt.setString(1, tempName);
			pstmt.setString(2, objName);
			rs = pstmt.executeQuery();

			if( rs.next() )
			{
				if( rs.getInt(1) == 0 )
				{
					pstmt.close();
					pstmt = null;
					
					rs.close();
					rs = null;

					//Changed By Ravindra C on 21-02-18 for[XmlType to CLOB ] 
					String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(TEMPLATE_ID, OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT, "
							+ "TEMPLATE_XML_NEW, FILE_MAPPING, ADD_USER, ADD_DATE, ADD_TERM, CHG_USER, CHG_DATE, CHG_TERM, SHARE_SCOPE, SCOPE_VALUE, DOC_ID, RIGHTS_CHAR, ACTIVE, AUTO_CONFIRM) "
							//+ " VALUES (?,?,?,?,?,XMLType(?), XMLType(?),?,?,?,?,?,?,?,?,?,?)";
							+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

					BaseLogger.log("3", userInfo,  null,"insertTemplate = "+insertTemplate);
					pstmt = conn.prepareStatement(insertTemplate);
					pstmt.setString(1, tranId);
					pstmt.setString(2, objName);
					pstmt.setString(3, tempName);
					pstmt.setString(4, ""); 
					pstmt.setString(5, isDefault);
					CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					xmlData.putString( 1, xmlString );
					pstmt.setClob(6, xmlData);
					CLOB fileMappingData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
					fileMappingData.putString( 1, fileMapping );
					pstmt.setClob(7, fileMappingData);
					pstmt.setString(8, loginCode);
					pstmt.setTimestamp(9,new java.sql.Timestamp( System.currentTimeMillis()));
					pstmt.setString(10, chgTerm);
					pstmt.setString(11, loginCode);
					pstmt.setTimestamp(12,new java.sql.Timestamp( System.currentTimeMillis()));
					pstmt.setString(13, chgTerm);
					pstmt.setString(14, shareScope);
					pstmt.setString(15, scopeValue);  
					pstmt.setString(16, docId);  
					pstmt.setString(17, templateRightsChar);
					pstmt.setString(18, "Y"); 
					//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
					pstmt.setString(19, isDataUploadAutoConfirm); 
				}
				else
				{
					pstmt.close();
					pstmt = null;
					
					rs.close();
					rs = null;

					if ( byteArray != null )
					{
						String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = ?, "
								+ " FILE_MAPPING = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ?, SHARE_SCOPE = ?, SCOPE_VALUE = ?, DOC_ID = ?, RIGHTS_CHAR = ?, AUTO_CONFIRM = ?"  		
								+ " WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ? AND TEMPLATE_ID = ? ";
						BaseLogger.log("3", userInfo,  null,"updateTemplate = "+updateTemplate);
						pstmt = conn.prepareStatement(updateTemplate);
						pstmt.setString(1, "");
						pstmt.setString(2, isDefault);
						CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
						xmlData.putString( 1, xmlString );
						pstmt.setClob(3, xmlData);
						CLOB fileMappingData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
						fileMappingData.putString( 1, fileMapping );
						pstmt.setClob(4, fileMappingData);
						pstmt.setString(5, loginCode);
						pstmt.setTimestamp(6,new java.sql.Timestamp( System.currentTimeMillis()));
						pstmt.setString(7, chgTerm);
						pstmt.setString(8, shareScope);
						pstmt.setString(9, scopeValue);
						pstmt.setString(10, docId);
						pstmt.setString(11, templateRightsChar); 
						pstmt.setString(12, isDataUploadAutoConfirm);  
						pstmt.setString(13, tempName);   
						pstmt.setString(14, objName);
						pstmt.setString(15, tempId);  
					}
					else
					{
						String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = ?, "
								+ " FILE_MAPPING = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ?, SHARE_SCOPE = ?, SCOPE_VALUE = ?, RIGHTS_CHAR = ?, AUTO_CONFIRM = ? "  		
								+ " WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ? AND TEMPLATE_ID = ? ";
						BaseLogger.log("3", userInfo,  null,"updateTemplate = "+updateTemplate);
						pstmt = conn.prepareStatement(updateTemplate);
						pstmt.setString(1, "");
						pstmt.setString(2, isDefault);
						CLOB xmlData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
						xmlData.putString( 1, xmlString );
						pstmt.setClob(3, xmlData);
						CLOB fileMappingData = CLOB.createTemporary( conn.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
						fileMappingData.putString( 1, fileMapping );
						pstmt.setClob(4, fileMappingData);
						pstmt.setString(5, loginCode);
						pstmt.setTimestamp(6,new java.sql.Timestamp( System.currentTimeMillis()));
						pstmt.setString(7, chgTerm);
						pstmt.setString(8, shareScope);
						pstmt.setString(9, scopeValue);
						pstmt.setString(10, templateRightsChar);
						pstmt.setString(11, isDataUploadAutoConfirm);
						pstmt.setString(12, tempName);   
						pstmt.setString(13, objName);
						pstmt.setString(14, tempId);
					}
				}
				int result = pstmt.executeUpdate();

				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				if( result > 0 )
				{
					respString = "<Root><Detail>Success</Detail></Root>";
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null, "Exception in userInfo saveTemplate - ["+ e.getMessage() +"]" );
			isError = true;
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					if ( ! isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return respString;
	}
	//Changed by Ajinkya D on 16-NOV-2017 [For Upload Utility] [END]
	
	private String generateTranId( String windowName, Connection conn )throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			BaseLogger.log("3", null,  null,"keyString :"+keyString);
			BaseLogger.log("3", null,  null,"keyCol :"+keyCol);
			BaseLogger.log("3", null,  null,"tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "</Detail1></Root>";
			BaseLogger.log("3", null,  null,"xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			BaseLogger.log("3", null,  null,"tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			BaseLogger.log("0", null,  null,"Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null,  null,"Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
		return tranId;
	}
	//Added by Prasad on 20/09/17 [] END
	/*public String getUploadStatusData(String batchId) throws RemoteException, ITMException 
	{
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer result = new StringBuffer();
		try
		{
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG " +
					" FROM BATCHLOAD " +
					" WHERE  BATCH_ID = ? " +
					" AND LOAD_STAT in ('N','E','Y') " +
					" ORDER BY TO_NUMBER(TRAN_SL)";
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
			SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				result.append("<ROOT>");
				do
				{
					result.append("<DETAIL>");
					result.append("<BATCH_ID><![CDATA[").append( checkNull(batchId )).append("]]></BATCH_ID>");
					result.append("<WIN_NAME><![CDATA[").append(checkNull( rs.getString(1) )).append("]]></WIN_NAME>");
					result.append("<TRAN_SL><![CDATA[").append( rs.getInt(2) ).append("]]></TRAN_SL>");
					result.append("<TRAN_ID_REF><![CDATA[").append(checkNull( rs.getString(4) != null?rs.getString(4):"" )).append("]]></TRAN_ID_REF>");
					result.append("<LOAD_DATE><![CDATA[").append(checkNull(sdfdate.format(rs.getTimestamp(3))) ).append("]]></LOAD_DATE>");
					result.append("<LOAD_STAT><![CDATA[").append( rs.getInt(5) ).append("]]></LOAD_STAT>");
					result.append("<ERROR_MSG><![CDATA[").append( checkNull(rs.getString(6))).append("]]></ERROR_MSG>");
					result.append("</DETAIL>");
				}
				while(rs.next());
				result.append("</ROOT>");
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("3", userInfo,  null,"Exception on getUploadStatusData-1907---["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return result.toString();
	}*/
	
	public String getUploadStatusData(String batchId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException 
	{
		ConnDriver connDriver = null;  
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer result = new StringBuffer();
		String retResult = "";
		boolean localConn = false;
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			//Changed By Ravindra C on 27-06-18 to get the upload File Name 
			//String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, LOAD_STAT, BATCH_ID, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG " +
			String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, LOAD_STAT, BATCH_ID, DATA_FILE_NAME, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG " +
					" FROM BATCHLOAD " +
					" WHERE BATCH_ID = ? " +
					" AND LOAD_STAT in ('N','E','Y') " +
					" ORDER BY TO_NUMBER(TRAN_SL)";
			if ( conn == null )
			{
				connDriver = new ConnDriver();
				//if(transDB!=null && (transDB.trim().length() >0 ))
				{
					conn = connDriver.getConnectDB( transDB );
				}
				connDriver = null;
				localConn = true;
			}
			
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			//SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
			SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
			HashMap<String, HashMap<String,String>> dataMap = new HashMap<String, HashMap<String,String>>(); 

            int totalRec = 0, transl = 0, processed = 0, successRec = 0, errorRec = 0, unProcessed = 0;
			String objName = "", loadStatus = "", tranIdRef = "",errorMsg = "",winName= "", dataFileName = "";
			String loadDate = "";
			rs = pstmt.executeQuery();
			
			if( rs.next() )
			{
				result.append("<ROOT>");
				do
				{
					totalRec ++;
					
					winName = checkNull(rs.getString(1));
					if( winName.length() > 2)
					{
						objName = winName.substring( 2 );
					}
					transl = rs.getInt(2);
					
					loadDate = rs.getTimestamp(3) != null ? (sdfdate.format(rs.getTimestamp(3))) : "";
					//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
					//BaseLogger.log("3", userInfo,  null, "2161 batchId - ["+batchId+"]" );
					
					tranIdRef = rs.getString(4) != null ? rs.getString(4) : "";
					loadStatus = rs.getString(5);
					batchId = rs.getString(6);
					//Added By Ravindra C on 27-06-18 to get the File Name
					dataFileName = rs.getString(7);
					errorMsg = rs.getString(8);
					
					result.append("<DETAIL>");
					result.append("<BATCH_ID><![CDATA[").append( checkNull(batchId )).append("]]></BATCH_ID>");
					result.append("<WIN_NAME><![CDATA[").append(checkNull( rs.getString(1) )).append("]]></WIN_NAME>");
					result.append("<TRAN_SL><![CDATA[").append( transl ).append("]]></TRAN_SL>");
					result.append("<TRAN_ID_REF><![CDATA[").append( checkNull( tranIdRef ) ).append("]]></TRAN_ID_REF>");
					result.append("<LOAD_DATE><![CDATA[").append( checkNull( loadDate ) ).append("]]></LOAD_DATE>");
					result.append("<LOAD_STAT><![CDATA[").append( loadStatus ).append("]]></LOAD_STAT>");
					//Added By Ravindra C on 27-06-18 to get the File Name
					result.append("<DATA_FILE_NAME><![CDATA[").append( dataFileName ).append("]]></DATA_FILE_NAME>");
					result.append("<ERROR_MSG><![CDATA[").append( checkNull( errorMsg )).append("]]></ERROR_MSG>");
					result.append("</DETAIL>");
					
					if ( "Y".equalsIgnoreCase( loadStatus ) )
					{
						successRec ++;
					}
					else if ( "E".equalsIgnoreCase( loadStatus ) )
					{
						errorRec ++;
					}
					else if ( "N".equalsIgnoreCase( loadStatus ) )
					{
						unProcessed ++;
					}
					
					processed = successRec + errorRec;
					//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
					//BaseLogger.log("3", userInfo,  null,"dataMap ["+dataMap+"]");
					
				} while( rs.next() );
				result.append("</ROOT>");
			}
			
			HashMap<String, String> metadataMap = new HashMap<String, String>();
			int percentage = (processed * 100) / totalRec;
			metadataMap.put( "batchId", batchId );
			metadataMap.put( "objName", objName );
			metadataMap.put( "totalRec", ""+totalRec );
			metadataMap.put( "successRec", ""+successRec );
			metadataMap.put( "errorRec", ""+errorRec );
			metadataMap.put( "unProcessed", ""+unProcessed );
			metadataMap.put( "processed", ""+processed );
			metadataMap.put( "progress", processed + " / " + totalRec );
			metadataMap.put( "percentage", ""+percentage );
			//Added By Ravindra C on 27-06-18 to get the File Name
			metadataMap.put( "dataFileName", ""+dataFileName );
			
			metadataMap.put( "response", ""+result );
			
			BaseLogger.log("3", userInfo,  null, "successRec - ["+ successRec +"], errorRec - ["+ errorRec +"], unProcessed - ["+ unProcessed +"]" );
			BaseLogger.log("3", userInfo,  null, "processed - ["+ processed +"]" );
			BaseLogger.log("3", userInfo,  null, "loadDate - ["+ loadDate +"], tranIdRef -["+tranIdRef+"]");
			dataMap.put(batchId, metadataMap);
			
			JSONObject resultJson = new JSONObject();
			for ( Map.Entry<String, HashMap<String, String>> entry : dataMap.entrySet() )
			{
				String mapBatchId = entry.getKey();
				metadataMap = entry.getValue();
				if ( metadataMap != null )
				{
					JSONObject metadataJson = new JSONObject();
					for ( Map.Entry<String, String> entry1 : metadataMap.entrySet() )
					{
						metadataJson.put( entry1.getKey(), entry1.getValue() );
					}
					resultJson.put( mapBatchId, metadataJson );
				}
			}
			retResult = resultJson.toString();
			BaseLogger.log("3", userInfo,  null,"retResult ---["+ retResult +"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null,"Exception on getUploadStatusData----["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(localConn && conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return retResult;
	}
	
	//Changed by Prasad on 07/03/18 [to get upload status data datewise]
	
	//added by Sainath T. and Sadique on 31/1/2019-start[to get upload status data in json array format]
	public String getUploadStatusDataArray(String batchId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException 
	{ 
	
		BaseLogger.log("3", userInfo,  null,"In upload status data array:");
		ConnDriver connDriver = null;  
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer result = new StringBuffer();
		String retResult = "";
		boolean localConn = false;
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo,  null,"batchId [" +batchId+"]");
						
			/*String getErrorData = "SELECT WIN_NAME AS Win_Name, TRAN_SL as Tran_Sl, LOAD_DATE as DateTime, TRAN_ID__REF as Transaction_Id, LOAD_STAT as Load_State, BATCH_ID as Batch_Id, DATA_FILE_NAME as Data_File_Name, (CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END) as Message " +
					" FROM BATCHLOAD " +
					" WHERE BATCH_ID = ? " +
					" AND LOAD_STAT in ('N','E','Y') " +
					" ORDER BY TO_NUMBER(TRAN_SL)";*/
			//Changed by Pooja S on 12-July-2019 [to display the background job status on clcik of the done ] start
			String getErrorData ="";
			if(batchId.indexOf("-") == -1)
			{
				getErrorData = "SELECT CREATED_DATE as DateTime,JOB_ID as Transaction_Id, (CASE WHEN JOB_STAT IN('I','C') THEN 'Successfully Sent.' ELSE REMARKS END) as Message "
						+ "FROM BACKGROUND_JOB  "
						+ "WHERE JOB_ID = ?  AND JOB_STAT in ('X','E','I','P','C')  "
						+ "ORDER BY TO_NUMBER(QUEUE_ID)";
			}
			else
			{
				getErrorData = "SELECT LOAD_DATE as DateTime, TRAN_ID__REF as Transaction_Id,(CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END) as Message " +
						" FROM BATCHLOAD " +
						" WHERE BATCH_ID = ? " +
						" AND LOAD_STAT in ('N','E','Y') " +
						" ORDER BY TO_NUMBER(TRAN_SL)";
				
			}
			//Changed by Pooja S on 12-July-2019 [to display the background job status on clcik of the done ] End
			if ( conn == null )
			{
				connDriver = new ConnDriver();
				
				{
					conn = connDriver.getConnectDB( transDB );
				}
				connDriver = null;
				localConn = true;
			}
			pstmt = conn.prepareStatement(getErrorData);
			pstmt.setString(1, batchId) ;
			SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
            int totalRec = 0, transl = 0, processed = 0, successRec = 0, errorRec = 0, unProcessed = 0;
			String objName = "", loadStatus = "", tranIdRef = "",errorMsg = "",winName= "", dataFileName = "";
			String loadDate = "";
			int srNo=0;
			rs = pstmt.executeQuery();
			JSONObject JsonData =new JSONObject();
			JSONArray tempJson1 = new JSONArray();
			ResultSetMetaData metaData = rs.getMetaData();
			int count = metaData.getColumnCount();//number of column
			String columnName;
			tempJson1.put("Sr.No");
/*			JSONArray visible = new JSONArray();
			visible.put(1);*/
			
			//for css data
			JSONArray cssJson =new JSONArray();
			cssJson.put("numberClass");
			for (int i = 1; i <= count; i++)
			{
				//columnName[i-1] = metaData.getColumnLabel(i);
				columnName = metaData.getColumnLabel(i);
				BaseLogger.log("3", userInfo,  null,"column names are["+columnName+"]");
				
			/*	//To generate visible array-start
				if(columnName.equalsIgnoreCase("WIN_NAME")|| columnName.equalsIgnoreCase("TRAN_SL")|| columnName.equalsIgnoreCase("LOAD_STAT")|| columnName.equalsIgnoreCase("BATCH_ID") || columnName.equalsIgnoreCase("DATA_FILE_NAME"))
				{
					visible.put(0);   //to hide column
				}
				else
				{
					visible.put(1);    //to show column
				}//To generate visible array-end
			 */				
				columnName = columnName.replace("_", " ");
				//for Camel case
				String camelColumnName=camelCase(columnName.toLowerCase());
				BaseLogger.log("3", userInfo,  null,"Camel case["+camelColumnName+"]");
			
				tempJson1.put(camelColumnName);
				
				if(camelColumnName.equalsIgnoreCase("Transaction Id"))
				{
					cssJson.put("numberClass");
				}
				else if(camelColumnName.equalsIgnoreCase("DateTime"))
				{
					cssJson.put("dateClass");
				}
				else
				{
					cssJson.put("textClass");
				}

			}
			JsonData.put("cols", tempJson1);
			JsonData.put("colStyle", cssJson);
			//JsonData.put("visible", visible);
			
			if( rs.next() )
			{
				JSONArray tempJson = new JSONArray();
				do
				{
					
					srNo++;
				
					loadDate = rs.getTimestamp("DateTime") != null ? (sdfdate.format(rs.getTimestamp("DateTime"))) : "";
					BaseLogger.log("3", userInfo,  null,"2161 DateTime - ["+loadDate+"]");


					tranIdRef = rs.getString("Transaction_Id") != null ? rs.getString("Transaction_Id") : "";
					errorMsg = rs.getString("Message");
					BaseLogger.log("3", userInfo,  null,"Sr.no : ["+srNo+"], tranIdRef - ["+ tranIdRef +"],errorMsg - ["+ errorMsg +"]");
					JSONArray tempJson2 = new JSONArray();
					tempJson2.put(""+srNo);
					tempJson2.put( ""+loadDate );
					tempJson2.put( ""+tranIdRef );
					tempJson2.put( ""+errorMsg );
					tempJson.put(tempJson2);
					
				} while( rs.next() );
				JsonData.put("rows",tempJson );
			}
			retResult = JsonData.toString();
			BaseLogger.log("3", userInfo,  null,"retResult ---["+ retResult +"]");
			
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null,"Exception on getUploadStatusDataArray----["+e.getMessage()+"]");
			
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(localConn && conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return retResult;
	}
	//for camel case-start
		String camelCase(String str)
		{
			StringBuilder builder = new StringBuilder(str);
			// Flag to keep track if last visited character is a 
			// white space or not
			boolean isLastSpace = true;
			
			// Iterate String from beginning to end.
			for(int i = 0; i < builder.length(); i++)
			{
				char ch = builder.charAt(i);
				
				if(isLastSpace && ch >= 'a' && ch <='z')
				{
					// Character need to be converted to uppercase
					builder.setCharAt(i, (char)(ch + ('A' - 'a') ));
					isLastSpace = false;
				}
				else if (ch != ' ')
					isLastSpace = false;
				else
					isLastSpace = true;
			}
		
			return builder.toString();
		}
		////for camel case-start-end
	//added by Sainath T. on 14/08/2018-end[to get upload status data in json array format]
	//public String getAllUploadStatusData( UserInfoBean userInfo ) throws RemoteException, ITMException
	public String getAllUploadStatusData( UserInfoBean userInfo, String loadDate ) throws RemoteException, ITMException 
	{
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String retResult = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			String transDB = userInfo.getTransDB();
			String getErrorData = " SELECT WIN_NAME, BATCH_ID, "
					+ " COUNT(BATCH_ID) AS TOTAL_CNT, "
					+ " SUM(CASE WHEN LOAD_STAT = 'Y' THEN 1 ELSE 0 END) AS SUCC_CNT, "
					+ " SUM(CASE WHEN LOAD_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT, "
					+ " SUM(CASE WHEN LOAD_STAT = 'N' THEN 1 ELSE 0 END) AS PEND_CNT "
					+ " FROM BATCHLOAD "
					+ " WHERE LOAD_STAT IN ('N','E','Y') "
					+ " AND LOAD_DATE > ? AND LOAD_DATE < ? "
					+ " AND CHG_USER = ? "
					+ " GROUP BY WIN_NAME, BATCH_ID "
					+ " ORDER BY WIN_NAME, BATCH_ID DESC";
			
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			connDriver = null;
			
			pstmt = conn.prepareStatement(getErrorData);
			
			SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getApplDateFormat() );
		    Date date = sdf.parse( loadDate );
		    
		    Calendar calendar = Calendar.getInstance();
		    calendar.setTime( date );
		    calendar.add( Calendar.DATE, 1 );
		    Date nextDay = calendar.getTime();
			
		    String currDate = sdf.format( date );
		    currDate = genericUtility.getValidDateString( currDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy" );
			
		    String nextDate = sdf.format( nextDay );
		    nextDate = genericUtility.getValidDateString( nextDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy" );
		    
		    BaseLogger.log("3", userInfo,  null, "currDate : ["+ currDate +"], nextDate : ["+ nextDate +"]" );
		    
			pstmt.setString( 1, currDate );
			pstmt.setString( 2, nextDate );
			pstmt.setString( 3, userInfo.getLoginCode() ) ;

            int totalRec = 0, processed = 0, successRec = 0, errorRec = 0, unProcessed = 0;
			String objName = "", loadStatus = "", batchId = "";
			
			rs = pstmt.executeQuery();
			
			//Changed By Ravindra - 04-10-18 - for Decending order.
			//JSONObject resultJson = new JSONObject();
			JSONArray resultJson = new JSONArray();
			if( rs.next() )
			{
				do
				{
					batchId = rs.getString( "BATCH_ID" );
					
					objName = rs.getString( "WIN_NAME" );
					objName = objName.substring( 2 );
					totalRec = rs.getInt( "TOTAL_CNT" );
					successRec = rs.getInt( "SUCC_CNT" );
					errorRec = rs.getInt( "ERR_CNT" );
					unProcessed = rs.getInt( "PEND_CNT" );
					processed = successRec + errorRec;
					
					float percentage = (processed * 100) / totalRec;
					
					BaseLogger.log("3", userInfo,  null, "batchId : ["+ batchId +"], successRec - ["+ successRec +"], errorRec - ["+ errorRec +"], unProcessed - ["+ unProcessed +"], processed - ["+ processed +"]" );
					
					JSONObject tempJson = new JSONObject();
					tempJson.put( "batchId", batchId );
					tempJson.put( "objName", objName );
					tempJson.put( "totalRec", ""+totalRec );
					tempJson.put( "successRec", ""+successRec );
					tempJson.put( "errorRec", ""+errorRec );
					tempJson.put( "unProcessed", ""+unProcessed );
					tempJson.put( "processed", ""+processed );
					tempJson.put( "progress", processed + " / " + totalRec );
					tempJson.put( "percentage", ""+percentage );
					tempJson.put( "loadStatus", loadStatus );
					
					//Changed By Ravindra - 04-10-18 - for Desending Order.
					resultJson.put( tempJson );

				} while( rs.next() );
			}
			retResult = resultJson.toString();
			BaseLogger.log("3", userInfo,  null,"retResult ---["+ retResult +"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null,"Exception on getallUploadStatusData----["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return retResult;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	public String getDataFileName(String batchId, UserInfoBean userInfo) 
	{
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String downloadFile = "";
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo,  null,"batchId " +batchId);
			String fileName = " select data_file_name from BATCHLOAD where batch_id = ?";
			
			connDriver = new ConnDriver();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			pstmt = conn.prepareStatement(fileName);
			pstmt.setString(1, batchId) ;
			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				downloadFile = checkNull(rs.getString(1));
			}
			//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
			//BaseLogger.log("3", userInfo,  null,"retResult ---["+ downloadFile +"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,  null,"Exception on getUploadStatusData----["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return downloadFile;
	}
	
	private String addDocument( String refId, String objName, String tempName, String fileName, byte[] byteArray, String filePath, UserInfoBean userInfo ) throws Exception
	{
		String retString = null;

		try
		{
			String refSer = "";
			if( checkNull( objName ).length() > 0 )
			{
				//DBAccessRemote dbAccess = (DBAccessRemote)getInitialContext().lookup("ibase/DBAccessEJB/remote");
				DBAccessEJB dbAccess = new DBAccessEJB();
				refSer = dbAccess.getRefSer( null, "obj_file_template", userInfo );
				dbAccess = null;
			}
			String user = userInfo.getLoginCode();
			
			String fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );

			//Added by Prasad on 18/01/19 [call documenthandlerEJB instead of documentHandlerServlet] START
			StringBuffer retXMLStrBuff = new StringBuffer();
			retXMLStrBuff.append("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?>");
			retXMLStrBuff.append("<DocumentRoot>");
			retXMLStrBuff.append("<description>Datawindow Root</description>");
			retXMLStrBuff.append("<group0>");
			retXMLStrBuff.append("<description>Group0 description</description>");
			retXMLStrBuff.append("<Header0>");
			retXMLStrBuff.append("<description>Header0 members</description>");
			retXMLStrBuff.append("<header>");
			retXMLStrBuff.append("<ref_id><![CDATA["+ refId +"]]></ref_id>");
			retXMLStrBuff.append("<ref_col><![CDATA[]]></ref_col>");
			retXMLStrBuff.append("<obj_name><![CDATA["+ objName +"]]></obj_name>");
			retXMLStrBuff.append("<ref_ser><![CDATA["+ refSer +"]]></ref_ser>");
			retXMLStrBuff.append("<doc_name><![CDATA["+ fileName +"]]></doc_name>");
			retXMLStrBuff.append("<doc_type><![CDATA["+ fileType +"]]></doc_type>");
			retXMLStrBuff.append("<document_type><![CDATA[]]></document_type>");
			retXMLStrBuff.append("<file_type><![CDATA[]]></file_type>");
			retXMLStrBuff.append("<created_by><![CDATA["+user+"]]></created_by>");
			retXMLStrBuff.append("</header>");
			retXMLStrBuff.append("</Header0>");
			retXMLStrBuff.append("</group0>");
			retXMLStrBuff.append("</DocumentRoot>");
			
			//DocumentHandlerRemote docHandler = (DocumentHandlerRemote)getInitialContext().lookup("ibase/DocumentHandlerEJB/remote");
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			retString = docHandler.addDocument( retXMLStrBuff.toString(), byteArray, null, userInfo );
			//retString = docHandler.addDocument( objName, refId, refSer, "", null, "", "", filePath, null, null, 0, null, null, userInfo );
			//Changed by Prasad on 25/05/18 [enterprise implementation in attachment]
			//retString = docHandler.addDocument( retXMLStrBuff.toString(), byteArray, null, userInfo.getTransDB() );
			//Added by Prasad on 18/01/19 [call documenthandlerEJB instead of documentHandlerServlet] END
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		catch (Exception e)
		{
			throw e;
		}
		return retString;
	}
	
	private InitialContext getInitialContext()
	{
		InitialContext ctx = null;
		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return ctx;
	}
	
	private String getDocumentId( String documentStr ) throws ITMException
	{
		String docId = "";
		if ( checkNull( documentStr ).length() > 0 )
		{
			Document dom = new E12GenericUtility().parseString(documentStr);
			NodeList nodeList = dom.getElementsByTagName( "Document" );
			Node node = nodeList.item(0);
			NodeList childList = node.getChildNodes();
			if ( childList != null ) 
			{
				for (int i = 0; i < childList.getLength(); i++) 
				{
					Node childNode = childList.item(i);
					if (childNode != null) 
					{
						String childNodeName = childNode.getNodeName();
						if (checkNull(childNodeName).length() > 0) 
						{
							if ( childNodeName.equalsIgnoreCase("ID") ) 
							{
								docId = childNode.getAttributes().getNamedItem("Document_Id").getNodeValue();
							}
						}
					}
				}
			}
		}
		BaseLogger.log("2", null,  null, "docId - ["+ docId +"]" );
		return docId;
	}
	
	//Added By Ravindra C on 17-04-18 for ProfileId -[Start] 
	private String appendProfileIdQueryCond( String profileId )
	{
		String query = "";
		if ( profileId != null )
		{
			query = "AND (";
			String[] profile = profileId.split(",");
			for ( String pro : profile )
			{
				query = query + " TEMP.SCOPE_VALUE LIKE '%" + pro.trim() +  "%' " + "OR ";
			}
			query = query.substring( 0, query.lastIndexOf( "OR" ) );
			
			query = query +")";
			
			BaseLogger.log("3", null,  null,"In the Query Method===>"+query);
		}
		return query;
	}
	//Added By Ravindra C on 17-04-18 for ProfileId -[End]

	//Added By Ravindra C  on 23-04-18 for Check template exist or not - Start
	public boolean checkExistingTempName(String objName, String tempName, UserInfoBean userInfo  )
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;
			String getTempCont = "SELECT COUNT(*) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
			BaseLogger.log("3", userInfo,  null," getTempCont===> oooooo --->[" + getTempCont + "]");
			pstmt = conn.prepareStatement(getTempCont);
			pstmt.setString(1, tempName);
			pstmt.setString(2, objName);
			rs = pstmt.executeQuery();
			int count = 0;
			if (rs.next())
			{
				count = rs.getInt(1);
			}
			if(count > 0)
			{
				return true;
			}
			rs.close();
			pstmt.close();
			conn.close();
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo,  null,"In the Exception Catch Block==> ["+ e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return false;
	}
	//Added By Ravindra C  on 23-04-18 for Check template exist or not - End
	//Added By Ravindra C on 10-08-18 to get DocId for Download Document  - Start
	public String getDocId(String batchId, String refSer, UserInfoBean userInfo)
	{
		String responseStr ="";
		String docId ="";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;               
			String sql = "SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_ID = ? AND REF_SER = ?";
			BaseLogger.log("3", userInfo,  null," getTempCont : [" + sql + "]");
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, batchId);
			pstmt.setString(2, refSer); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				docId = rs.getString("DOC_ID");
				responseStr = docId;
				BaseLogger.log("3", userInfo,  null,"getDocId response : ["+ responseStr +"]");
			}
			rs.close();
			pstmt.close();
			conn.close();
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo,  null," getDocId Exception : ["+ e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return responseStr ;
	}
	//Added By Ravindra C on 10-08-18 to get DocId for Download Document  - End

	//added By Ravindra C on 10-08-18 to get docId And refId - Satrt
	public String getDocIdNrefId(String objName, String tempName, UserInfoBean userInfo) 
	{
		String responseStr ="";
		String docId ="";
		String refId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;               
			String sql = "SELECT DOC_ID,TEMPLATE_ID FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND TMP_NAME = ?";
			BaseLogger.log("3", userInfo,  null," getDocIdNrefId sql : [" + sql + "]");
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			pstmt.setString(2, tempName); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				docId = rs.getString("DOC_ID");
				refId = rs.getString("TEMPLATE_ID");
				responseStr = refId + "&" + docId;
				BaseLogger.log("3", userInfo,  null,"getDocIdNrefId response : ["+ responseStr +"]");
			}
			rs.close();
			pstmt.close();
			conn.close();
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo,  null," getDocIdNrefId Exception : ["+ e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return responseStr ;
	}
	//added By Ravindra C on 10-08-18 to get docId And refId - End
	
	//Added by Ravindra C on 14-1-19 to delete existing template - Start
	public String deleteTemplate( String tempName, String objName, UserInfoBean userInfo) 
	{
		String updatedTempName = tempName+"_delete";
		BaseLogger.log("3", null, null, "updatedTempName :: ["+ updatedTempName +"]");
		String tempStatus = "N";
		String resStr = "";
		int updateCnt = 0;
		Connection conn = null;
		PreparedStatement pstmt = null;
		boolean isError = false;
		try 
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null; 
			String updateSql = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_NAME = ?, ACTIVE = ?, CHG_DATE = ? where TEMPLATE_NAME = ? and OBJ_NAME = ?";

			BaseLogger.log("3", null, null, " deactivteTemplate updateSql : [" + updateSql + "]");
			pstmt = conn.prepareStatement(updateSql);
			pstmt.setString(1, updatedTempName);
			pstmt.setString(2, tempStatus); 
			pstmt.setTimestamp(3, new java.sql.Timestamp( System.currentTimeMillis()));
			pstmt.setString(4, tempName);
			pstmt.setString(5, objName);
			updateCnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			BaseLogger.log("3", null, null, "OBJ_FILE_TEMPLATE : updateCnt : ["+ updateCnt +"]" );
			if( updateCnt == 1 )
			{
				resStr ="Success";
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("3", null, null, " deactivteTemplate Exception : ["+ e.getMessage()+"]");
			isError = true;
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					if ( ! isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return resStr;
	}
	//Added by Ravindra C on 14-1-19 to delete existing template - End
	
	//added by Ravindra c on 08-02-19 to check User's right for process template - Start   
	public String getUserRightInfo( String objName, String loginCode, UserInfoBean userInfo)throws RemoteException,ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		String  mQuery = null;		
		String profileId = null;
		String strRights = "";
		String transDB = null;
		try
		{
			transDB = userInfo.getTransDB();
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			profileId = E12GenericUtility.checkNull(userInfo.getProfileId());
			mQuery = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND OBJ_NAME ='"+objName+"'";
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);

			while ( mRs.next())
			{
				strRights += E12GenericUtility.checkNull(mRs.getString( "RIGHTS" ));
			}
			BaseLogger.log("3", null, null, "getUserRightInfo strRights :["+ strRights +"]");

			if ( mStmt != null )
			{
				mStmt.close();
				mStmt =null;
			}
			if ( mRs != null )
			{
				mRs.close();
				mRs =null;
			}				
		}
		catch (Exception e)
		{ 
			BaseLogger.log("3", null, null, "getUserRightInfo Exception :[" +e.getMessage() +"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( mRs != null )
				{
					mRs.close();
					mRs = null;
				}
				if( mStmt != null )
				{
					mStmt.close();
					mStmt = null;
				}
				if( mConnection != null )
				{					
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return strRights;
	}
	//added by Ravindra c on 08-02-19 to check User's right for process template - end
	
	//Added by Pankaj P on 25/05/2021 [to update batchid status] START
	public String updateBatchloadStatus( String batchId, int tranSl, String status, UserInfoBean userInfo, Connection conn ) throws ITMException
	{
		String retString = "";
		PreparedStatement psUpdateBl = null;
		boolean isLocalConn = false;
		try
		{
			if( conn == null )
			{
				ConnDriver mConnDriver = new ConnDriver();
				conn = mConnDriver.getConnectDB( userInfo.getTransDB() );
				mConnDriver = null;
				isLocalConn = true;
			}
			
			String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";		
			psUpdateBl = conn.prepareStatement( update );
			psUpdateBl.setString( 1, status );
			psUpdateBl.setTimestamp( 2, new java.sql.Timestamp( System.currentTimeMillis() ) );
			psUpdateBl.setString( 3, userInfo.getLoginCode() );
			psUpdateBl.setString( 4, userInfo.getRemoteHost() );
			psUpdateBl.setString( 5, batchId );
			psUpdateBl.setInt( 6, tranSl );

			int updateCnt = psUpdateBl.executeUpdate();
			
			String message = "No record updated";
			if ( updateCnt > 0 )
			{
				message = updateCnt +" record updated";
			}
			retString = "<Root><Detail><message><![CDATA["+ message +"]]</message></Detail></Root>";

			psUpdateBl.close();
			psUpdateBl = null;
			
			BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: ["+ updateCnt +"]" );
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : updateBatchloadStatus :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : updateBatchloadStatus :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try
			{
				if( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.commit();
					conn = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
			}
		}
		return retString;
	}
	//Added by Pankaj P on 25/05/2021 [to update batchid status] END
	
	//Added By Pankaj T. on 06-07-2022 [To add validation for daily upload limit against enterprise ] - start
	public boolean checkDailyUploadLimitExcced( UserInfoBean userInfo ) throws ITMException
	{
		boolean dailyUploadLimitExceed = false;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		Connection conn = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( userInfo.getTransDB() );
			int dailyUploadLimit = 0;
			String uploadLimitSQL = "SELECT DAILY_UPLOAD_LIMIT FROM ENTERPRISE WHERE ENTERPRISE = ?";
			preparedStatement = conn.prepareStatement(uploadLimitSQL);
			preparedStatement.setString(1, userInfo.getEnterprise());
			resultSet = preparedStatement.executeQuery();
			if( resultSet.next() )
			{
				dailyUploadLimit = resultSet.getInt("DAILY_UPLOAD_LIMIT");
			}
			BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() DAILY_UPLOAD_LIMIT against enterprise ["+userInfo.getEnterprise()+"] "+": ["+dailyUploadLimit+"]");
			preparedStatement.close();
			preparedStatement = null;
			resultSet.close();
			resultSet = null;
			
			int batchLoadCount = 0;
			String bathlodCountSQL = "SELECT count(*) as count FROM BATCHLOAD B, USERS U WHERE B.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND TRUNC(B.CHG_DATE) = TO_DATE(SYSDATE, 'dd-mm-yy')";
			preparedStatement = conn.prepareStatement(bathlodCountSQL);
			preparedStatement.setString(1, userInfo.getEnterprise());
			resultSet = preparedStatement.executeQuery();
			if( resultSet.next() )
			{
				batchLoadCount = resultSet.getInt("count");
			}
			BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() batchLoadCount : ["+batchLoadCount+"]");
			preparedStatement.close();
			preparedStatement = null;
			resultSet.close();
			resultSet = null;
			
			if( dailyUploadLimit != 0 && batchLoadCount > dailyUploadLimit )
			{
				dailyUploadLimitExceed = true;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() Exception : ["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( preparedStatement != null )
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					if( resultSet != null )
					{
						resultSet.close();
						resultSet = null;
					}
					if( conn != null )
					{
						conn.close();
						conn = null;
					}
				}
			}
			catch (Exception e2)
			{
				BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() Exception in finally : ["+E12GenericUtility.getStackTrace(e2)+"]");
			}
		}
		BaseLogger.log("2", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() DAILY_UPLOAD_LIMIT exceed : ["+dailyUploadLimitExceed+"]");
		return dailyUploadLimitExceed;
	}
	//Added By Pankaj T. on 06-07-2022 [To add validation for daily upload limit against enterprise ] - end
}
